/*
 * GMSSampleAppMainActivity
 * Primary activity for application
 * 
 *  Disclaimer: IMPORTANT:  This sample software is supplied to you by Genesys
 Telecommunications Laboratories Inc ("Genesys") in consideration of your agreement
 to the following terms, and your use, installation, modification or redistribution
 of this Genesys software constitutes acceptance of these terms.  If you do not
 agree with these terms, please do not use, install, modify or redistribute this
 Genesys software.
 
 In consideration of your agreement to abide by the following terms, and subject
 to these terms, Genesys grants you a personal, non-exclusive license, under
 Genesys's copyrights in this original Genesys software (the "Genesys Software"), to
 use, reproduce, modify and redistribute the Genesys Software, with or without
 modifications, in source and/or binary forms; provided that if you redistribute
 the Genesys Software in its entirety and without modifications, you must retain
 this notice and the following text and disclaimers in all such redistributions
 of the Genesys Software.
 
 Neither the name, trademarks, service marks or logos of Genesys Inc. may be used
 to endorse or promote products derived from the Genesys Software without specific
 prior written permission from Genesys.  Except as expressly stated in this notice,
 no other rights or licenses, express or implied, are granted by Genesys herein,
 including but not limited to any patent rights that may be infringed by your
 derivative works or by other works in which the Genesys Software may be
 incorporated.
 
 The Genesys Software is provided by Genesys on an "AS IS" basis.  GENESYS MAKES NO
 WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED
 WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE, REGARDING THE GENESYS SOFTWARE OR ITS USE AND OPERATION ALONE OR IN
 COMBINATION WITH YOUR PRODUCTS.
 
 IN NO EVENT SHALL GENESYS BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR
 CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
 GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, MODIFICATION AND/OR
 DISTRIBUTION OF THE GENESYS SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF
 CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF
 GENESYS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
 Copyright (C) 2012 Genesys Inc. All Rights Reserved.

*/
package com.genesyslab.gms.android;

import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.concurrent.CountDownLatch;

import org.json.JSONException;
import org.json.JSONObject;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.AdapterView;
import android.widget.AdapterView.OnItemSelectedListener;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

import com.genesyslab.gms.android.framework.GMSEvent;
import com.genesyslab.gms.android.framework.GenesysMobileService;
import com.genesyslab.gms.android.framework.GenesysMobileServiceListener;
import com.genesyslab.gms.android.framework.GenesysMobileServiceRequest;
 
public class GMSSampleAppMainActivity extends Activity implements Observer, GenesysMobileServiceListener {
	// application configuration data
	private SharedPreferences prefs = null;
	private static final String SETTINGS_FILENAME = "GMSSampleAppSettingsFile";
	private static final String SPINNER_POS = "spinner_pos";
	private static final String REQUEST_TEXT = "request_text";
	private static final String RESPONSE_TEXT = "response_text";
	private static final String REGISTRATION_ID = "registration_id";
	
	// view controls
	private Spinner spnService = null;
	private EditText textRequest = null;
	private EditText textResponse = null;
	private Button btnMakeCall = null;
	
	// identifiers for PerformServiceRequests
	static final int BasicMatch = 0;
	static final int InboundImmediate = 1;
	static final int InboundDelayed = 2;
	static final int OutboundImmediate = 3;
	static final int OutboundDelayed = 4;
	static final int InboundDelayedPolled = 5;
	static final int Reserve = 6;
	static final int Accept = 7;
	static final int Status = 8;
	
	// progress dialog
	ProgressDialog progressDialog;
	static final int PROGRESS_DIALOG = 0;
	
	// C2DM messaging
	public String registration_id = null;
	public String error = null;
	public String message = null;
	
	// delay service synchronization
	private CountDownLatch C2DMRegistrationSignal = null;
	
	String gms_host = null;
	String gms_user = null;
	String gms_password = null;
	String session_id = null;
	private boolean isRemoteStart = false;
	GenesysMobileService gmsService;
	int currentRequest;
	
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.main);
        prefs = PreferenceManager.getDefaultSharedPreferences(this);
        
        spnService = (Spinner) findViewById(R.id.spinnerServices);
        ArrayAdapter<CharSequence> adapter = ArrayAdapter.createFromResource(
                this, R.array.services, android.R.layout.simple_spinner_item);
        adapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        spnService.setAdapter(adapter);
        spnService.setOnItemSelectedListener(new OnItemSelectedListener() {
		
			public void onItemSelected(AdapterView<?> arg0, View arg1,
					int arg2, long arg3) {
				if(!isRemoteStart){
					textRequest.setText("");
					textResponse.setText("");
				}
			}

		
			public void onNothingSelected(AdapterView<?> arg0) {
				if(!isRemoteStart){
					textRequest.setText("");
					textResponse.setText("");
				}
			}
        });
        
        btnMakeCall = (Button) findViewById(R.id.btnMakeCall);
        // assign OnClick listeners
        btnMakeCall.setOnClickListener(new OnClickListener() {
			public void onClick(View v) {
				// get service selected in spinner and pass to Execute Service 
				int item = spnService.getSelectedItemPosition();
				// clear previous request/response
				textRequest.setText("");
        		textResponse.setText("");
        		// execute service
    			PerformService(item);
			}
        });
        textRequest = (EditText) findViewById(R.id.textRequest);
        textResponse = (EditText) findViewById(R.id.textResponse);
        // disable soft keyboard 
        textRequest.setKeyListener(null);
        textResponse.setKeyListener(null);
        
        // register for c2dm notifications
        MessageHandler.getInstance().addObserver(this); 
        
        // if the extras are set this indicates the activity is being started due to 
        // a message being received from C2DM so we need to retrieve the apps saved state
        // restore the UI to the last state then respond to the message sent in the extras bundle passed
        // to the activity
        Bundle extras = getIntent().getExtras();
        if(extras != null) {
        	Log.d("GMSSampleAppMainActivity", "onCreate - extras != null");
        	isRemoteStart = true;
        	// restore UI state from values saved in onStop 
        	SharedPreferences settings = getSharedPreferences(SETTINGS_FILENAME, 0);
        	registration_id = settings.getString(REGISTRATION_ID, null);
        	spnService.setEnabled(false);
        	spnService.setSelection(settings.getInt(SPINNER_POS, 0));
        	spnService.setEnabled(true);
        	textRequest.setText(settings.getString(REQUEST_TEXT, ""));
        	textResponse.setText(settings.getString(RESPONSE_TEXT, ""));
           	//store the notification message for future consumption
        	String remoteStartMessage = extras.getString("message");
        	if (remoteStartMessage != null) { //We started with a remote notification message
        		GMSEvent gmsEvent = new GMSEvent(this);
        		gmsEvent.setGmsResponse(remoteStartMessage);
            	onServerEvent(gmsEvent);
        	}
        }
        else {
			C2DMRegistrationSignal = new CountDownLatch(1); //This signal will be sent when the app has registered for notifications
			String c2dmEmail = prefs.getString("c2dm_sender_id", null);
			if (c2dmEmail != null) {
				registerC2DM(c2dmEmail);
			}
			else {
				AlertDialog.Builder builder = new AlertDialog.Builder(this);
    			builder.setMessage("Please ensure your device has a Google account, update the app settings with a c2dm registered email and restart the app")
    					.setTitle("C2DM Registration Failed")
    					.setCancelable(false)  
    					.setNeutralButton("Close", new DialogInterface.OnClickListener() {           
    						public void onClick(DialogInterface dialog, int id) {                
    							dialog.cancel();           
    						}       
    					});
    			AlertDialog alert = builder.create();
    			alert.show();				
			}
        }
    }
    
	// The activity is about to become visible.    
    @Override    
    protected void onStart() {        
    	super.onStart();
	    Log.d("GMSSampleAppMainActivity", "onStart");
    }    
	// The activity has become visible (it is now "resumed").
    @Override    
    protected void onResume() {        
    	super.onResume();
    	Log.d("GMSSampleAppMainActivity", "onResume");
    }    
	// Another activity is taking focus (this activity is about to be "paused").
    @Override    
    protected void onPause() {        
    	super.onPause(); 
    	Log.d("GMSSampleAppMainActivity", "onPause");
    }    
	// The activity is no longer visible (it is now "stopped")
    @Override    
    protected void onStop() {        
    	super.onStop();
    	Log.d("GMSSampleAppMainActivity", "onStop");
    	SharedPreferences settings = getSharedPreferences(SETTINGS_FILENAME, 0);
    	SharedPreferences.Editor editor = settings.edit();
    	editor.putInt(SPINNER_POS, spnService.getSelectedItemPosition());
    	editor.putString(REQUEST_TEXT, textRequest.getText().toString());
    	editor.putString(RESPONSE_TEXT, textResponse.getText().toString());
    	editor.putString(REGISTRATION_ID, registration_id);
    	editor.commit();
    }    
	// The activity is about to be destroyed.
    @Override    
    protected void onDestroy() {        
    	super.onDestroy();
    	Log.d("GMSSampleAppMainActivity", "onDestroy");
    	MessageHandler.getInstance().deleteObserver(this);
    	if (this.gmsService != null) {
        	MessageHandler.getInstance().deleteObserver(this.gmsService);    		
    	}
    }
    
    /*
     * Called when a dialog is created
     * @see android.app.Activity#onCreateDialog(int)
     */
    protected Dialog onCreateDialog(int id) {
    	Dialog dlg = null;
    	
    	switch(id) {    
			case PROGRESS_DIALOG:            
				progressDialog = new ProgressDialog(GMSSampleAppMainActivity.this);            
				progressDialog.setMessage("Executing service request...");            
				return progressDialog;
    		default:        
    			dlg = null;    
    	}    
    	return dlg;
    }

    /*
     * Initiates service request
     */
    protected void PerformService(int item) {
        try {
            if (this.gmsService == null) {
                prefs = PreferenceManager.getDefaultSharedPreferences(this);
                gms_host = prefs.getString("gms_host", null);
                gms_user = prefs.getString("gms_user", null);
                gms_password = prefs.getString("gms_password", null);
            	this.gmsService = new GenesysMobileService(gms_host, gms_user, gms_password);
            	this.gmsService.addEventListener(this);
            	MessageHandler.getInstance().addObserver(this.gmsService); //For GMS Notifications
            }
        	
        	if((gms_host != null) && (gms_host.length() > 0)){
        		this.currentRequest = item;
        		new BuildRequestTask().execute(item); //Scenario for which we will build the request in the background
        	}
        	else {
        		AlertDialog.Builder builder = new AlertDialog.Builder(this);
    			builder.setMessage("Go to Settings and define required configuration data.")
    					.setTitle("Configuration Data Missing")
    					.setCancelable(false)  
    					.setNeutralButton("Close", new DialogInterface.OnClickListener() {           
    						public void onClick(DialogInterface dialog, int id) {                
    							dialog.cancel();           
    						}       
    					});
    			AlertDialog alert = builder.create();
    			alert.show();
        	}
        } catch (Exception ex){
        	textResponse.setText(ex.toString());
        }
    }
    
    /*
     * Performs Service Selected
     * AsyncTask class to handle all requests in a worker thread
     */
    private class BuildRequestTask extends AsyncTask<Integer, GenesysMobileServiceRequest, GenesysMobileServiceRequest> {
    	Exception lastException = null;
    	
    	// called before worker thread is started
    	// display progress dialog to keep user entertained
    	protected void onPreExecute(){
		    Log.d("GMSSampleAppMainActivity", "BuildRequestTask.onPreExecute");
	        showDialog(PROGRESS_DIALOG);
			progressDialog.setMessage("Executing service request...");
    	}

    	// code executed in worker thread 
    	protected GenesysMobileServiceRequest doInBackground(Integer... params) {        
		    //Initialize request
		    GenesysMobileServiceRequest gmsRequest = new GenesysMobileServiceRequest();
		    int currentRequest = params[0];
		    
		    try {
			    //Phone Number
		    	String phonenumber = getDeviceNumber();
		    	if(phonenumber.length() > 0){
		    		// phone number is restricted to 10 digits so extract 10 LSDs
		    		if(phonenumber.length() > 10)
		    			phonenumber = phonenumber.substring(phonenumber.length() - 10);
		    	}
	
			    gmsRequest.addValue("_phone_number", phonenumber);
			    gmsRequest.addValue("_provide_code", "true");
		    	
		        // Location
		    	Location location = getDeviceLocation();
		        if(location != null) {
		        	String latitude = Double.toString(location.getLatitude());
		        	String longitude = Double.toHexString(location.getLongitude());
				    gmsRequest.addValue("_current_location_latitude", latitude);
				    gmsRequest.addValue("_current_location_longitude", longitude);
		        }
		        
		        //Language
		        String language = getLanguage();
		        if(language.length() > 0){
				    gmsRequest.addValue("device_language", language);
		        }
		        
		        //Country code
		    	String countrycode = getCountryCode();
		        if(countrycode.length() > 0){
				    gmsRequest.addValue("country_code", countrycode);
		        }
	
		        //Push Notification Registration ID
		        if ((currentRequest == InboundDelayed) || (currentRequest == OutboundDelayed)) {
   					// register with c2dm if we don't already have a registration id
   					if(registration_id == null) {
   						// wait for registration to complete
   						progressDialog.setMessage("Registering for Notifications...");
   						C2DMRegistrationSignal = new CountDownLatch(1); //This signal will be sent when the app has registered for notifications
   						String c2dmEmail = prefs.getString("c2dm_sender_id", null);
   						registerC2DM(c2dmEmail);
   						C2DMRegistrationSignal.await();	
   					}
		        	
		            gmsRequest.addValue("_device_notification_id", registration_id); //C2DM Registration ID
		            gmsRequest.addValue("_device_os", "android"); //Device OS
		        }
	
		        //You can insert your business object as serialized JSON 
		        //You can also add images/binary attachments as part of the request
		        gmsRequest.addValue("custom_data", "Your can add any custom data with a custom parameter name");
		            		        
				Log.d("PerformService " + currentRequest, gmsRequest.getRequestBodyAsString());
				publishProgress(gmsRequest);
		    }
		    catch(Exception e) {
		    	this.lastException = e;
		    	gmsRequest = null;
     		}		    
		    
		    return gmsRequest;
    	}   
    	
    	// display progress updates in UI
    	protected void onProgressUpdate(GenesysMobileServiceRequest... params){
		    Log.d("GMSSampleAppMainActivity", "BuildRequestTask.onProgressUpdate");
		    GenesysMobileServiceRequest gmsRequest = (GenesysMobileServiceRequest) params[0];
	    	textRequest.setText(gmsRequest.getRequestBodyAsString()); //This is only for demo purposes
			progressDialog.setMessage("Sending Request...");
    	}
    	
    	// Called after worker thread completes
    	//The request has been built. Now call the service.
    	protected void onPostExecute(GenesysMobileServiceRequest gmsRequest) {   
		    Log.d("GMSSampleAppMainActivity", "BuildRequestTask.onPostExecute");
		    
		    if (gmsRequest != null) {
    	        // retrieve url based on service being exercised				
				String serviceAlias = "";
	    	    if(currentRequest == BasicMatch)
	    	       serviceAlias = prefs.getString("basic_match_url", null);
	    	    else if(currentRequest == InboundImmediate)
	    	        serviceAlias = prefs.getString("inbound_immediate_url", null);
	    	    else if(currentRequest == OutboundImmediate)
	    	        serviceAlias = prefs.getString("outbound_immediate_url", null);
	       	    else if(currentRequest == InboundDelayed)
	    	        serviceAlias = prefs.getString("inbound_delayed_url", null);
	    	    else if(currentRequest == OutboundDelayed)
	    	        serviceAlias = prefs.getString("outbound_delayed_url", null);
	    	    else if(currentRequest == InboundDelayedPolled)
	    	        serviceAlias = prefs.getString("inbound_delayed_polled_url", null);

		        gmsService.createService(gmsRequest, serviceAlias);
		    }
		    else {
		    	try {
		    		dismissDialog(PROGRESS_DIALOG);
		    	}
		    	catch(IllegalArgumentException e) {}
	       		AlertDialog.Builder builder = new AlertDialog.Builder(getParent());
    			builder.setMessage(this.lastException.toString())
    					.setTitle("Error building request")
    					.setCancelable(false)  
    					.setNeutralButton("Close", new DialogInterface.OnClickListener() {           
    						public void onClick(DialogInterface dialog, int id) {                
    							dialog.cancel();           
    						}       
    					});
    			AlertDialog alert = builder.create();
    			alert.show();		    	
		    }
    	}
    }
       
    /*
     * Dials call
     */
    private void DialCall(final String number) {
    	try {
    		// display alert dialog to user to allow them to choose to dial access number received
			AlertDialog.Builder builder = new AlertDialog.Builder(this);
			builder.setMessage("Do you wish to speak with the agent?")
					.setTitle("An Agent is now available")
					.setCancelable(false)       
					.setPositiveButton("Yes", new DialogInterface.OnClickListener() {           
						public void onClick(DialogInterface dialog, int id) {                
							if(number.length() > 0) {
				    			String telnumber = "tel:" + number;
				        		Intent callIntent = new Intent(Intent.ACTION_CALL, Uri.parse(telnumber));
				        		startActivity(callIntent);	
				    		}           
						}       
					})       
					.setNegativeButton("No", new DialogInterface.OnClickListener() {           
						public void onClick(DialogInterface dialog, int id) {                
							dialog.cancel();           
						}       
					});
			AlertDialog alert = builder.create();
			alert.show();
    	}
    	catch (Exception ex){
    		textResponse.append(ex.toString());
    	}
    }
                 
    /*
     * Initializes options menu
     * @see android.app.Activity#onCreateOptionsMenu(android.view.Menu)
     */
    public boolean onCreateOptionsMenu(Menu menu) {    
    	MenuInflater inflater = getMenuInflater();    
    	inflater.inflate(R.menu.main_menu, menu);    
    	return true;
    }
    
    /*
     * Handles menu item selection
     * @see android.app.Activity#onOptionsItemSelected(android.view.MenuItem)
     */
    public boolean onOptionsItemSelected(MenuItem item) {    
    	// Handle item selection    
    	switch (item.getItemId()) {        
    		case R.id.menuSettings:
    			Intent prefsIntent = new Intent(this, EditPreferences.class);
    			startActivity(prefsIntent);
    			return true;        
    		default:            
    			return super.onOptionsItemSelected(item);    
    	}
    }
    
    /*
     * Initiates C2DM registration
     */
    private void registerC2DM(String c2dmEmail) {
    	Intent registrationIntent = new Intent("com.google.android.c2dm.intent.REGISTER");
    	registrationIntent.putExtra("app", PendingIntent.getBroadcast(this, 0, new Intent(), 0));
    	registrationIntent.putExtra("sender", c2dmEmail); 
    	startService(registrationIntent);	
    }
    
    /*
     * Retrieve device location from device
     */
    private Location getDeviceLocation() {
    	// Or use LocationManager.GPS_PROVIDER
    	// Acquire a reference to the system Location Manager 
    	LocationManager locationManager = (LocationManager) this.getSystemService(GMSSampleAppMainActivity.LOCATION_SERVICE);
    	Location lastKnownLocation = locationManager.getLastKnownLocation(LocationManager.GPS_PROVIDER);
		return lastKnownLocation;
    }
    
    /*
     * Retrieves phone number from device
     */
    private String getDeviceNumber() {
    	TelephonyManager telephony = (TelephonyManager)this.getSystemService(TELEPHONY_SERVICE); 
    	return telephony.getLine1Number();
    }
    
    /*
     * Retrieves country code from device
     */
    private String getCountryCode() {
    	TelephonyManager telephony = (TelephonyManager)this.getSystemService(TELEPHONY_SERVICE); 
    	return telephony.getNetworkCountryIso();
    }
    
    /*
     * Retrieves language from device
     */
    private String getLanguage() {
    	Locale lc = Locale.getDefault();
    	return lc.getDisplayLanguage();
    }

    /*
     * Handles notifications from C2DMReceiver
     * @see java.util.Observer#update(java.util.Observable, java.lang.Object)
     */
	
	public void update(Observable arg0, Object arg1) {
		if (arg1 instanceof Bundle) {
			Bundle bundle = (Bundle) arg1;
			String type = bundle.getString("type");
			// registration message
			if(type.contains("c2dmregistration")){
				registration_id = bundle.getString("registration_id");
				error = bundle.getString("error");
				Log.d("GMSSampleAppMainActivity", ".update - type: c2dmregistration; registration_id:" + registration_id + ";error: " + error);

				if ((registration_id == null) && (error != null)) {
					AlertDialog.Builder builder = new AlertDialog.Builder(this);
	    			builder.setMessage("Please ensure your device has a Google account, update the app settings with a c2dm registered email and restart the app")
	    					.setTitle("Registration Failed: " + error)
	    					.setCancelable(false)  
	    					.setNeutralButton("Close", new DialogInterface.OnClickListener() {           
	    						public void onClick(DialogInterface dialog, int id) {                
	    							dialog.cancel();           
	    						}       
	    					});
	    			AlertDialog alert = builder.create();
	    			alert.show();
				}
				
				// signal any waiting threads to continue
				C2DMRegistrationSignal.countDown();				
			}
			//notification message
			else if(type.contains("c2dmmessage")){
				//Implement application specific messages here
				//GMS Messages will come as events to onServerEvent
			}
		}
	}
	
	/*
	 * The following section is the implementation of the GenesysMobileServiceListener methods
	 * These are all callbacks from Genesys Mobile Services
	 */
	
	/**
	 * Callback method when you successfully create a Genesys Mobile Service Request
	 * A JSon String is sent as response
	 */
	public void onCreateGenesysMobileService(GMSEvent event) {
		textResponse.setText(event.toString());
    	try {
    		dismissDialog(PROGRESS_DIALOG);
    	}
    	catch(IllegalArgumentException e) {}
		
		switch(this.currentRequest) {
			case BasicMatch:
			case InboundImmediate:
				try {
					JSONObject json = new JSONObject(event.toString());
					if(json.has("_access_number")){
						String phone_number = (String)json.getString("_access_number"); 
						if(json.has("_access_code")){
							phone_number += ",,";
							phone_number += (String)json.getString("_access_code");
						}
						// launch dialer with number provided
						DialCall(phone_number);
					}
				}
				catch(Exception e) {
		       		AlertDialog.Builder builder = new AlertDialog.Builder(this);
	    			builder.setMessage("There was an error reading the response.")
	    					.setTitle("Invalid Response")
	    					.setCancelable(false)  
	    					.setNeutralButton("Close", new DialogInterface.OnClickListener() {           
	    						public void onClick(DialogInterface dialog, int id) {                
	    							dialog.cancel();           
	    						}       
	    					});
	    			AlertDialog alert = builder.create();
	    			alert.show();
				}
				break;
			case InboundDelayedPolled:
    		    //Initialize request
    		    GenesysMobileServiceRequest gmsRequest = new GenesysMobileServiceRequest();
    		    try {
    		    	showDialog(PROGRESS_DIALOG);
					progressDialog.setMessage("Polling Agent Availability...");

					JSONObject json = new JSONObject(event.toString());
					if(json.has("_id")){
						session_id = (String)json.getString("_id"); 
					}
    		    	gmsRequest.addValue("_provide_code", "true");
    		    	Log.d("Request Access Request", gmsRequest.getRequestBodyAsString());
    		    	this.currentRequest = Status;
    		    	gmsService.performAction(prefs.getString("status_sessionid_url", null), session_id, gmsRequest);
    		    }
    		    catch(Exception e) {
		       		AlertDialog.Builder builder = new AlertDialog.Builder(this);
	    			builder.setMessage("There was an error reading the response.")
	    					.setTitle("Invalid Response")
	    					.setCancelable(false)  
	    					.setNeutralButton("Close", new DialogInterface.OnClickListener() {           
	    						public void onClick(DialogInterface dialog, int id) {                
	    							dialog.cancel();           
	    						}       
	    					});
	    			AlertDialog alert = builder.create();
	    			alert.show();
    		    }				
			default:
				break;

				// For Inbound Delay, we wait for a notification to come from the server that the agent is available
				// for OutboundImmediate and OutboundDelayed we don't make the call, it comes from the enterprise so once we have 
				// completed the required requests we are done
		}
	}

	/**
	 * Called if there was an error creating the service
	 */
	public void onFailWithError(GMSEvent event) {
    	try {
    		dismissDialog(PROGRESS_DIALOG);
    	}
    	catch(IllegalArgumentException e) {}

   		AlertDialog.Builder builder = new AlertDialog.Builder(this);
		builder.setMessage(event.toString())
				.setTitle("There was an error communicating with GMS")
				.setCancelable(false)  
				.setNeutralButton("Close", new DialogInterface.OnClickListener() {           
					public void onClick(DialogInterface dialog, int id) {                
						dialog.cancel();           
					}       
				});
		AlertDialog alert = builder.create();
		alert.show();		
	}

	/**
	 * Called when an action is performed on a Genesys Session
	 */
	public void onActionPerformed(GMSEvent event) {
    	try {
    		dismissDialog(PROGRESS_DIALOG);
    	}
    	catch(IllegalArgumentException e) {}
		
		if (this.currentRequest == Status) { //Polled Status
			onServerEvent(event);
			return;
		}
		
		if (this.currentRequest == Accept) { //Accept Enterprise initiated call
			textResponse.setText(event.toString());
		}
		
		try {
			JSONObject json = new JSONObject(event.toString());
			if(json.has("_access_number")){
				String phone_number = (String)json.getString("_access_number"); 
				if(json.has("_access_code")){
					phone_number += ",,";
					phone_number += (String)json.getString("_access_code");
				}
				// launch dialer with number provided
    			String telnumber = "tel:" + phone_number;
        		Intent callIntent = new Intent(Intent.ACTION_CALL, Uri.parse(telnumber));
        		startActivity(callIntent);	
			}
		}
		catch(Exception e) {
       		AlertDialog.Builder builder = new AlertDialog.Builder(this);
			builder.setMessage("There was an error reading the response.")
					.setTitle("Invalid Response")
					.setCancelable(false)  
					.setNeutralButton("Close", new DialogInterface.OnClickListener() {           
						public void onClick(DialogInterface dialog, int id) {                
							dialog.cancel();           
						}       
					});
			AlertDialog alert = builder.create();
			alert.show();
		}
	}

	/**
	 * Placeholder for Push notifications handling in your callback delegate
	 * This method needs to be called from your push client when you receive notifications
	 */
	public void onServerEvent(GMSEvent event) {
        if (this.gmsService == null) { //In case the application was launched by a notification
            prefs = PreferenceManager.getDefaultSharedPreferences(this);
            gms_host = prefs.getString("gms_host", null);
            gms_user = prefs.getString("gms_user", null);
            gms_password = prefs.getString("gms_password", null);
        	this.gmsService = new GenesysMobileService(gms_host, gms_user, gms_password);
        	this.gmsService.addEventListener(this);
        	MessageHandler.getInstance().addObserver(this.gmsService); //For GMS Notifications
        }
		
		message = event.toString();
		Log.d("GMSSampleAppMainActivity", "type: GMS Server Event; message:" + message);
		// evaluate message
		try {
			JSONObject json;
			json = new JSONObject(message);
			
			if (json.has("message")) {
				json = new JSONObject(json.getString("message"));
			}
			
			if(json.has("_status")){
				String status = json.getString("_status");
				// status values containing "Agent Available" or "Accept Call" signal
				// the delay is completed so we need to tell the waiting thread to continue
				if(status.contains("Available")) {
					if(json.has("_id")){
						session_id = json.getString("_id");
						
			    		// display alert dialog to user to allow them to choose to communicate
						AlertDialog.Builder builder = new AlertDialog.Builder(this);
						builder.setMessage("Do you wish to speak with the agent?")
								.setTitle("An Agent is now available")
								.setCancelable(false)       
								.setPositiveButton("Yes", new DialogInterface.OnClickListener() {           
									public void onClick(DialogInterface dialog, int id) {                
						    		    //Initialize request
						    		    GenesysMobileServiceRequest gmsRequest = new GenesysMobileServiceRequest();
						    		    try {
						    		    	showDialog(PROGRESS_DIALOG);
					   						progressDialog.setMessage("Requesting access to the agent...");
						    		    	gmsRequest.addValue("_provide_code", "true");
						    		    	Log.d("Request Access Request", gmsRequest.getRequestBodyAsString());
						    		    	currentRequest = Reserve;
						    		    	gmsService.performAction(prefs.getString("reserve_sessionid_url", null), session_id, gmsRequest);
						    		    }
						    		    catch(Exception e) {
						    		    	Log.d("onServerEvent: Request-access", e.toString());
						    		    }
									}       
								})       
								.setNegativeButton("No", new DialogInterface.OnClickListener() {           
									public void onClick(DialogInterface dialog, int id) {                
										dialog.cancel();           
									}       
								});
						AlertDialog alert = builder.create();
						alert.show();
					}
				}
				else if(status.contains("Accept")){
					if(json.has("_id")){
						session_id = json.getString("_id");
						
			    		// display alert dialog to user to allow them to choose to communicate
						AlertDialog.Builder builder = new AlertDialog.Builder(this);
						builder.setMessage("Do you wish to speak with the agent?")
								.setTitle("An Agent is now available")
								.setCancelable(false)       
								.setPositiveButton("Yes", new DialogInterface.OnClickListener() {           
									public void onClick(DialogInterface dialog, int id) {                
						    		    //Initialize request
						    		    GenesysMobileServiceRequest gmsRequest = new GenesysMobileServiceRequest();
						    		    try {
						    		    	showDialog(PROGRESS_DIALOG);
					   						progressDialog.setMessage("Accepting invitation...");
						    		    	gmsRequest.addValue("_provide_code", "true");
						    		    	Log.d("Accept Request: ", gmsRequest.getRequestBodyAsString());
						    		    	currentRequest = Accept;
						    		    	gmsService.performAction(prefs.getString("accept_sessionid_url", null), session_id, gmsRequest);
						    		    }
						    		    catch(Exception e) {
						    		    	Log.d("onServerEvent: Request-access", e.toString());
						    		    }
									}       
								})       
								.setNegativeButton("No", new DialogInterface.OnClickListener() {           
									public void onClick(DialogInterface dialog, int id) {                
										dialog.cancel();           
									}       
								});
						AlertDialog alert = builder.create();
						alert.show();
					}
				}
				else if(this.currentRequest == Status) { //Poll says that agent is not available. So keep polling
	    		    //Initialize request
	    		    GenesysMobileServiceRequest gmsRequest = new GenesysMobileServiceRequest();
	    		    try {
	    		    	showDialog(PROGRESS_DIALOG);
   						progressDialog.setMessage("Polling agent availability...");
	    		    	gmsRequest.addValue("_provide_code", "true");
	    		    	Log.d("Poll Request: ", gmsRequest.getRequestBodyAsString());
	    		    	currentRequest = Status;
	    		    	gmsService.performAction(prefs.getString("status_sessionid_url", null), session_id, gmsRequest);
	    		    }
	    		    catch(Exception e) {
	    		    	Log.d("onServerEvent: Status", e.toString());
	    		    }					
				}
			}	
		}
		catch(JSONException ex){
			textResponse.setText(event.toString());
		}		
	}	
}